require( "scripts/style.lua" );


local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end

StandardButtonFontOK = {
  standardFont,
  32,
  BlackColor
};

vHSButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}

vHSButtonFontStyle = { standardFont, 16, BlackColor };


MakeDialog
{
	name=name, -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,

		SetStyle(DialogTitleText),
        Text
		{
			font = StandardButtonFontOK,
			name = "yesnotitle",
			label= gDialogTable.title,
			w = 300,
			x=kCenter,
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			font = StandardButtonFontOK,
			name = "yesnobody",
			label= gDialogTable.body,
			w = 380,
			x=kCenter,
		};

        SetStyle(ButtonStyle),
        Button
        {
			command=
				function()
					SendGameMessage("end_dialog");
					if (gDialogTable.yes) then 
						gDialogTable.yes() ; 
					end
				end;
            close = true,
            flags = 5,
            label = yes,
            name = yesname,
            graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
            x = kCenter-80,
            y = kMax-70,
        },
        Button
        {
			command=
				function() 
					SendGameMessage("end_dialog");
					if (gDialogTable.no) then
						gDialogTable.no() ; 
					end
                end;
            close = true,
            flags = 5,
            label = no,
            name = noname,
            hflip   = true,
            graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
            x = kCenter+80,
            y = kMax-70,
        },
        
    },

} -- MakeDialog
